-- T-SQL Window Funcions Deep Dive
-- Examples
USE AdventureWorks2014;
GO
--Islands
CREATE TABLE #Islands(Col1 INT NOT NULL ) ;

INSERT INTO #Islands (Col1) 
VALUES(1),(2),(3),(6),(8),(8),(9),(10),(11),(12),(12),(14),(15),(18),(19);

select * from #Islands;
/* we want results to look like this
1,3
6,6
8,12
14,15
18,19
*/

--Step 1: add Row_Number
SELECT Col1, Row_Number() OVER(ORDER BY Col1) FROM #Islands;

--since duplicates, change to DENSE_RANK
--Step 2: look at the difference
SELECT Col1,DENSE_RANK() OVER(ORDER BY Col1) , 
	Col1 - DENSE_RANK() OVER(ORDER BY Col1) 
FROM #Islands;

--Step 3: Use min and Max
;WITH I AS(SELECT Col1, Col1 - DENSE_RANK() 
	OVER(ORDER BY Col1) AS GRP FROM #Islands)
SELECT MIN(Col1) AS FirstItem, MAX(Col1) AS LastItem 
FROM I 
GROUP BY GRP;

--Find gaps 

--Start with Islands
;WITH I AS(SELECT Col1, Col1 - DENSE_RANK() 
	OVER(ORDER BY Col1) AS GRP FROM #Islands)
SELECT MIN(Col1) AS FirstItem, MAX(Col1) AS LastItem 
FROM I 
GROUP BY GRP;

--Use Lag and Lead
;WITH I AS(SELECT Col1, Col1 - DENSE_RANK() 
	OVER(ORDER BY Col1) AS GRP FROM #Islands),
ISLANDS AS (
	SELECT MIN(Col1) AS FirstItem, MAX(Col1) AS LastItem 
	FROM I 
	GROUP BY GRP)
SELECT LastItem + 1 AS StartOfGap, 
	LEAD(FirstItem) OVER(ORDER BY FirstItem) -1 AS EndOfGap
FROM ISLANDS;

--Remove last Row
;WITH I AS(SELECT Col1, Col1 - DENSE_RANK() 
	OVER(ORDER BY Col1) AS GRP FROM #Islands),
ISLANDS AS (
	SELECT MIN(Col1) AS FirstItem, MAX(Col1) AS LastItem 
	FROM I 
	GROUP BY GRP),
GAPS AS (
	SELECT LastItem + 1 AS StartOfGap, 
		LEAD(FirstItem) OVER(ORDER BY FirstItem) -1 AS EndOfGap
	FROM ISLANDS)
SELECT StartOfGap, EndOfGap 
FROM Gaps
WHERE EndOfGap IS NOT NULL;

--Even good performance on 30 million rows
SELECT COUNT(*) FROM bigTransactionHistory;

WITH 
Dates1 AS (
	SELECT DISTINCT TransactionDate 
	FROM bigTransactionHistory
	), 
Dates2 AS (
	SELECT TransactionDate, TransactionDate - ROW_NUMBER() 
	OVER(ORDER BY TransactionDate) AS Grp
	FROM Dates1)
SELECT MIN(TransactionDate) AS IslandStart, 
	MAX(TransactionDate) AS IslandEnd
FROM Dates2
GROUP BY GRP
ORDER BY MIN(TransactionDate);





--Fill in lastest value
--Thanks to Itzik Ben-Gan for his solution
CREATE TABLE #Test(Col1 INT, Col2 INT);

INSERT INTO #Test(Col1, Col2)
VALUES(1,1),(2,1),(3,NULL), 
	(4,NULL),(5,6),(6,NULL),
	(7,5),(8,10),(9,11);

SELECT * FROM #test;

--Itzik Solution step 1
SELECT Col1, Col2,
    MAX(CASE WHEN Col2 IS NOT NULL THEN Col1 END)
		OVER(ORDER BY Col1 ROWS UNBOUNDED PRECEDING) AS MaxRow
FROM #test;

WITH Vals AS
	(SELECT Col1, Col2,
		MAX(CASE WHEN Col2 IS NOT NULL THEN Col1 END)
			OVER(ORDER BY Col1 ROWS UNBOUNDED PRECEDING) AS MaxRow
	FROM #Test)
SELECT Col1, Col2,
	MAX(Col2) 
		OVER(PARTITION BY MaxRow ORDER BY Col1 ROWS UNBOUNDED PRECEDING) AS carryalongCol1
FROM Vals;




--Remove Duplicates
CREATE TABLE #temp(Col1 INT, Col2 INT);
INSERT INTO #temp(Col1,Col2)
VALUES(1,1),(1,1),(1,2),(1,3),(1,3),(1,3),(1,3);

SELECT Col1, Col2 FROM #temp;

SELECT Col1, Col2, 
	ROW_NUMBER() OVER(ORDER BY Col1) AS RowNbr
FROM #temp;

SELECT Col1, Col2, 
	ROW_NUMBER() OVER(PARTITION BY Col1, Col2 ORDER BY Col1) AS RowNbr
FROM #temp;

SELECT Col1, Col2, 
	ROW_NUMBER() OVER(PARTITION BY Col1, Col2 ORDER BY Col1) AS RowNbr
FROM #temp
WHERE ROW_NUMBER() OVER(PARTITION BY Col1, Col2 ORDER BY Col1) <> 1;

;WITH Rows AS(SELECT Col1, Col2, 
	ROW_NUMBER() OVER(PARTITION BY Col1, Col2 ORDER BY Col1) AS RowNbr
	FROM #temp)
SELECT Col1, Col2, RowNbr 
FROM Rows 
WHERE RowNbr <> 1;

;WITH Rows AS(SELECT Col1, Col2, 
	ROW_NUMBER() OVER(PARTITION BY Col1, Col2 ORDER BY Col1) AS RowNbr
	FROM #temp)
DELETE FROM Rows 
WHERE RowNbr <> 1;

SELECT Col1, Col2 FROM #temp;


--The first 4 orders in each year
;WITH Orders AS(
	SELECT CustomerID, SalesOrderID, OrderDate, 
		ROW_NUMBER() OVER(PARTITION BY YEAR(OrderDate) 
		ORDER BY OrderDate) AS RowNum, 
		YEAR(OrderDate) AS OrderYear
	FROM Sales.SalesOrderHeader)
SELECT CustomerID, SalesOrderID, OrderDate, OrderYear
FROM Orders
WHERE RowNum < 5;


--Window aggregate example
USE AdventureWorks2012;
GO
SELECT OBJECT_NAME(p.OBJECT_ID) TableName,
        ps.partition_number, 
        ps.row_count
FROM sys.data_spaces  d 
     JOIN sys.indexes i 
     JOIN (SELECT DISTINCT OBJECT_ID
             FROM sys.partitions
             WHERE partition_number > 1) p
           ON i.OBJECT_ID = p.OBJECT_ID
           ON d.data_space_id = i.data_space_id
     JOIN sys.dm_db_partition_stats ps
           ON i.OBJECT_ID = ps.OBJECT_ID and i.index_id = ps.index_id
WHERE i.index_id < 2;

SELECT OBJECT_NAME(p.OBJECT_ID) TableName,
        ps.partition_number, 
        ps.row_count, 
		ps.row_count * 100.00 /
		SUM(ps.row_count) OVER(PARTITION BY p.OBJECT_ID) 
FROM sys.data_spaces  d 
     JOIN sys.indexes i 
     JOIN (SELECT DISTINCT OBJECT_ID
             FROM sys.partitions
             WHERE partition_number > 1) p
           ON i.OBJECT_ID = p.OBJECT_ID
           ON d.data_space_id = i.data_space_id
     JOIN sys.dm_db_partition_stats ps
           ON i.OBJECT_ID = ps.OBJECT_ID and i.index_id = ps.index_id
WHERE i.index_id < 2;


--The Stock Problem!
SELECT * FROM StockAnalysis.dbo.StockHistory
ORDER BY TickerSymbol, TradeDate;

SELECT TickerSymbol, TradeDate, ClosePrice, 
	ClosePrice - LAG(ClosePrice,2) 
		OVER(PARTITION BY TickerSymbol 
		ORDER BY TradeDate) AS ClosePriceDIf
FROM StockAnalysis.dbo.StockHistory 
ORDER BY TickerSymbol, TradeDate;

--Can you create your own Window functions?

USE AdventureWorks2014;
GO
--Yes!!
BEGIN TRY
	DROP AGGREGATE Median;
	DROP ASSEMBLY PASSSummit;
END TRY
BEGIN CATCH
END CATCH;

GO
CREATE ASSEMBLY PASSSummit FROM
 'C:\PASSCLR\PassSummit\PassSummit\obj\Debug\PASSSummit.dll' WITH PERMISSION_SET = SAFE; 

GO

CREATE Aggregate Median (@Value INT) RETURNS INT
EXTERNAL NAME PASSSummit.Median;

GO

WITH Orders AS (
	SELECT CustomerID, SUM(OrderQty) AS OrderQty, SOH.SalesOrderID 
	FROM Sales.SalesOrderHeader AS SOH
	JOIN Sales.SalesOrderDetail AS SOD ON SOH.SalesOrderID = SOD.SalesOrderDetailID
	GROUP BY CustomerID, SOH.SalesOrderID)
SELECT CustomerID, OrderQty, dbo.Median(OrderQty) OVER(PARTITION BY CustomerID) AS Median
FROM Orders
WHERE CustomerID IN (13011, 13012, 13019);

